/******************************************************************************
 *
 *		7   S E G M E N T  M U X E D   D I S P L A Y   H E A D E R - Mikado Level
 *
 */
#ifndef DISPLAY_H
#define DISPLAY_H

// Hardware Pins
#define SEGMENTS		LATC
#define SEG_TRIS		TRISC
#define LED1			LATBbits.LATB5
#define LED1_TRIS		TRISBbits.TRISB5
#define LED2			LATAbits.LATA0
#define LED2_TRIS		TRISAbits.TRISA0
#define LED3			LATAbits.LATA5
#define LED3_TRIS		TRISAbits.TRISA5
#define LED4			LATAbits.LATA4
#define LED4_TRIS		TRISAbits.TRISA4

// Set up mux rate to 200 Hz: Fcy = 4MHz therefore N = 20,000
#define T1_RELOAD_LO	0xe0		// 0xb1e0 => 45,536 = 65,536 - 20,000
#define T1_RELOAD_HI	0xb1
#define FWD_REV            1
#define LFT_RGT            2

typedef unsigned char uchar;

void dispInitialise(void);
void dispDot(void);
void dispMux(void);
void dispBlank(void);
void dispHeel(signed int num);
void dispMax(unsigned int num);

#endif